; matrix4x4.asm
extern printf

section .data
	fmt0	db	10,"MACIERZE 4x4 WARTOŚCI ZMIENNOPRZECINKOWYCH PODWÓJNEJ PRECYZJI",10,0
    fmt1	db	10,"To macierz A:",10,0
	fmt2	db	10,"To macierz B:",10,0
	fmt3	db	10,"To macierz A x macierz B:",10,0
	fmt4	db	10,"To macierz C:",10,0
	fmt5	db	10,"To odwrotność macierzy C:",10,0
	fmt6	db	10,"Dowód: macierz C x macierz odwrotna =",10,0
 	fmt7	db	10,"To macierz S:",10,0
	fmt8	db	10,"To odwrotność macierzy_S:",10,0
	fmt9	db	10,"Dowód: macierz S x macierz odwrotna =",10,0
	fmt10	db	10,"Ta macierz jest osobliwa!",10,10,0
   
	align 32							
        matrixA     dq	 1.,  3.,  5.,  7.
                    dq	 9., 11., 13., 15.
                    dq	17., 19., 21., 23.
                    dq	25., 27., 29., 31.  

        matrixB     dq	 2.,  4.,  6.,  8.
                    dq	10., 12., 14., 16.
                    dq	18., 20., 22., 24.
                    dq	26., 28., 30., 32. 
 
        matrixC     dq	2.,		11.,		21.,     	37.
                    dq	3.,		13.,    	23.,     	41.
                    dq	5.,		17.,    	29.,     	43.
                    dq	7.,		19.,    	31.,    	47.   
 

        matrixS     dq	 1.,       2.,     	 3.,     	 4.
                    dq	 5.,       6.,     	 7.,     	 8.
                    dq	 9.,      10.,     	11.,     	12.
                    dq	13.,      14.,     	15.,     	16. 

section .bss
    	alignb 32
	product resq 16
	inverse resq 16
section .text							
	global main					
main:
push	rbp
mov	rbp,rsp
; wypisujemy tytuł
	mov 	rdi, fmt0
	call printf
; wypisujemy macierz A
	mov 	rdi,fmt1
	call printf
	mov 	rsi,matrixA
	call printm4x4
; wypisujemy macierz B
	mov 	rdi,fmt2
	call printf
	mov 	rsi,matrixB
	call printm4x4       
; obliczamy iloczyn macierz A x macierz B
	mov 	rdi,matrixA 
	mov 	rsi,matrixB
	mov 	rdx,product
	call multi4x4   
; wypisujemy iloczyn
	mov 	rdi,fmt3
	call printf
	mov 	rsi,product
	call printm4x4
; wypisujemy macierz C
	mov 	rdi,fmt4
	call printf
	mov 	rsi,matrixC
	call printm4x4 
; obliczamy macierz odwrotną do C  
	mov 	rdi,matrixC
	mov 	rsi,inverse
	call inverse4x4
	cmp 	rax,1
	je 	singular             
; wypisujemy macierz odwrotną
	mov 	rdi,fmt5
	call printf
	mov 	rsi,inverse
	call printm4x4
; dowód: mnożymy macierz C przez macierz odwrotną
	mov 	rsi,matrixC 
	mov 	rdi,inverse
	mov 	rdx,product
	call multi4x4          
; wypisujemy dowód
	mov 	rdi,fmt6
	call printf
	mov 	rsi,product
	call printm4x4

; macierz osobliwa
; wypisujemy macierz S
	mov 	rdi,fmt7
	call printf
	mov 	rsi,matrixS
	call printm4x4 
; obliczamy macierz odwrotną do S
	mov 	rdi,matrixS
	mov 	rsi,inverse
	call inverse4x4
	cmp 	rax,1
	je 	singular   
; wypisujemy macierz odwrotną
	mov 	rdi,fmt8
	call printf
	mov 	rsi,inverse
	call printm4x4
; dowód: mnożymy macierz S przez macierz odwrotną
	mov 	rsi,matrixS 
	mov 	rdi,inverse
	mov 	rdx,product
	call multi4x4          
; wypisujemy dowód
	mov 	rdi,fmt9
	call printf
	mov 	rsi,product
	call printm4x4  
	jmp	exit
singular:
; wypisujemy komunikat o błędzie
	mov 	rdi,fmt10
	call printf                                                          
exit:                                                                                                                                                                                                            
leave
ret

inverse4x4: 
section .data
	align 32                                                                                    
	.identity	dq       1., 0., 0., 0.
			dq       0., 1., 0., 0.
          	dq       0., 0., 1., 0.
        		dq       0., 0., 0., 1. 
      
	.minus_mask  dq      8000000000000000h
	.size        dq      4                 ; macierze 4 x 4
	.one         dq      1.0
	.two         dq      2.0
	.three       dq      3.0
	.four        dq      4.0

section .bss
	alignb 32
	.matrix1 resq 16		; macierz pośrednia
	.matrix2 resq 16		; macierz pośrednia
	.matrix3 resq 16		; macierz pośrednia
	.matrix4 resq 16		; macierz pośrednia
	.matrixI resq 16      

	.mxcsr resd 1		; do sprawdzania dzielenia przez zero

section .text							
push	rbp
mov	rbp,rsp
	push	rsi                 ; zapisujemy adres macierzy odwrotnej
	vzeroall		; zerujemy wszystkie rejestry ymm

; obliczamy macierze pośrednie
; obliczamy macierz pośrednią matrix2 
; rdi zawiera adres pierwotnej macierzy
	mov 	rsi,rdi 
	mov 	rdx,.matrix2
	push rdi
	call multi4x4
	pop 	rdi
 
; obliczamy macierz pośrednią matrix3 
 	mov 	rsi,.matrix2 
	mov 	rdx,.matrix3 
	push rdi   
	call multi4x4
	pop 	rdi
  
; obliczamy macierz pośrednią matrix4 
 	mov 	rsi,.matrix3 
	mov 	rdx,.matrix4
	push rdi    
	call multi4x4
	pop 	rdi

; obliczamy ślady
; obliczamy trace1
	mov 	rsi,[.size]
	call vtrace
	movsd xmm8,xmm0   ; ślad 1 w xmm8
; obliczamy trace2
	push rdi            ; zapisujemy adres pierwotnej macierzy
	mov 	rdi,.matrix2
	mov 	rsi,[.size]
	call vtrace
	movsd xmm9,xmm0   ; ślad 2 w xmm9    
; obliczamy trace3
	mov 	rdi,.matrix3
	mov 	rsi,[.size]
	call vtrace
	movsd xmm10,xmm0   ; ślad 3 w xmm10                              
; obliczamy trace4
	mov 	rdi,.matrix4
	mov 	rsi,[.size]
	call vtrace
	movsd xmm11,xmm0   ; ślad 4 w xmm11

; obliczamy współczynniki
; obliczamy współczynnik p1
; p1 = -s1
	vxorpd	xmm12,xmm8,[.minus_mask] ; p1 w xmm12
; obliczamy współczynnik p2
; p2 = -1/2 * (p1 * s1 + s2) 
	movsd 		xmm13,xmm12   ; kopiujemy p1 do xmm13
	vfmadd213sd 	xmm13,xmm8,xmm9 ; xmm13=xmm13*xmm8+xmm9
	vxorpd 		xmm13,xmm13,[.minus_mask]
	divsd 		xmm13,[.two]	; dzielimy przez 2 i p2 w xmm13
; obliczamy współczynnik p3
; p3 = -1/3 * (p2 * s1 + p1 * s2 + s3)
	movsd 		xmm14,xmm12               ; kopiujemy p1 do xmm14
	vfmadd213sd 	xmm14,xmm9,xmm10 ;p1*s2+s3;xmm14=xmm14*xmm9+xmm10
	vfmadd231sd 	xmm14,xmm13,xmm8 ;xmm14+p2*s1;xmm14=xmm14+xmm13*xmm8
	vxorpd 		xmm14,xmm14,[.minus_mask]
	divsd 		xmm14,[.three]             ;p3 w xmm14
; obliczamy współczynnik p4
; p4 = -1/4 * (p3 * s1 + p2 * s2 + p1 * s3 + s4)
	movsd 		xmm15,xmm12   ; kopiujemy p1 do xmm15
	vfmadd213sd 	xmm15,xmm10,xmm11 ;p1*s3+s4;xmm15=xmm15*xmm10+xmm11
	vfmadd231sd 	xmm15,xmm13,xmm9 ;xmm15+p2*s2;xmm15=xmm15+xmm13*xmm9
	vfmadd231sd 	xmm15,xmm14,xmm8 ;xmm15+p3*s1;xmm15=xmm15+xmm14*xmm8 
	vxorpd 		xmm15,xmm15,[.minus_mask]               
	divsd 		xmm15,[.four]	;p4 w xmm15
       
; mnożymy macierze przez odpowiednie współczynniki

	mov rcx,[.size]
	xor rax,rax

	vbroadcastsd	ymm1,xmm12 ; p1
	vbroadcastsd 	ymm2,xmm13 ; p2
	vbroadcastsd 	ymm3,xmm14 ; p3
    
	pop rdi     ; przywracamy adres pierwotnej macierzy

.loop1:
	vmovapd 	ymm0,[rdi+rax]	
	vmulpd 	ymm0,ymm0,ymm2
	vmovapd 	[.matrix1+rax],ymm0

	vmovapd 	ymm0,[.matrix2+rax]	
	vmulpd 	ymm0,ymm0,ymm1
	vmovapd 	[.matrix2+rax],ymm0

	vmovapd 	ymm0,[.identity+rax]
	vmulpd 	ymm0,ymm0,ymm3
	vmovapd 	[.matrixI+rax],ymm0

	add		rax,32
	loop 	.loop1

; dodajemy cztery macierze i mnożymy przez -1/p4
	mov 		rcx,[.size]
	xor 		rax,rax
; obliczamy -1/p4
	movsd 	xmm0, [.one]
	vdivsd 	xmm0,xmm0,xmm15	;1/p4
; sprawdzamy dzielenie przez zero
	stmxcsr 	[.mxcsr]
	and 		dword[.mxcsr],4
	jnz 		.singular         

; nie ma dzielenia przez zero
	pop 		rsi         ; przywracamy adres macierzy odwrotnej
	vxorpd 	xmm0,xmm0,[.minus_mask]  ;-1/p4
	vbroadcastsd ymm2,xmm0
         
; przetwarzamy wiersze w pętli
.loop2:
	; dodajemy wiersze
	vmovapd	ymm0,[.matrix1+rax]
	vaddpd 	ymm0, ymm0, [.matrix2+rax]
	vaddpd 	ymm0, ymm0, [.matrix3+rax]
	vaddpd 	ymm0, ymm0, [.matrixI+rax] 
	vmulpd 	ymm0,ymm0,ymm2  		; mnożymy wiersz przez -1/p4     
	vmovapd 	[rsi+rax],ymm0
	add 		rax,32 
	loop 	.loop2
        
	xor 		rax,rax     ; zwracamy 0, nie wykryto błędu
leave
ret

.singular:
	mov 		rax,1       ; zwracamy 1, macierz osobliwa
leave
ret
;------------------------------------------------------
; obliczanie śladu
vtrace:
push	rbp
mov	rbp,rsp
; budujemy macierz w pamięci
	vmovapd	ymm0, [rdi]
	vmovapd	ymm1, [rdi+32]
	vmovapd	ymm2, [rdi+64]
	vmovapd	ymm3, [rdi+96]
	vblendpd 	ymm0,ymm0,ymm1,0010b
	vblendpd 	ymm0,ymm0,ymm2,0100b
	vblendpd 	ymm0,ymm0,ymm3,1000b
	vhaddpd 	ymm0,ymm0,ymm0
	vpermpd 	ymm0,ymm0,00100111b
	haddpd 	xmm0,xmm0
leave
ret
;------------------------------------------------------
printm4x4:
section .data
	.fmt db	"%f",9,"%f",9, "%f",9,"%f",10,0
section .text
push	rbp
mov	rbp,rsp
push rbx	       	; zapisywany przez wywołanego
push r15        	; zapisywany przez wywołanego
	mov rdi,.fmt
	mov rcx,4
	xor rbx,rbx     	; licznik wierszy
.loop:        
	movsd xmm0, [rsi+rbx]
	movsd xmm1, [rsi+rbx+8]
	movsd xmm2, [rsi+rbx+16]
	movsd xmm3, [rsi+rbx+24]
	mov	rax,4		;four floats
	push rcx			; zapisywany przez wywołującego
	push rsi			; zapisywany przez wywołującego
	push rdi			; zapisywany przez wywołującego
        ; w razie potrzeby wyrównujemy stos
        xor r15,r15
        test rsp,0xf        ; ostatni bajt równy 8 (stos niewyrównany)? 
        setnz r15b          ; ustawiamy, jeśli niewyrównany
        shl r15,3           ; mnożymy przez 8
        sub rsp,r15         ; odejmujemy 0 lub 8
	call 	printf
        add rsp,r15         ; dodajemy 0 lub 8, aby przywrócić rsp
        pop rdi
        pop rsi
        pop rcx
        add rbx,32      ; następny wiersz
        loop .loop
pop r15
pop rbx
leave
ret
;------------------------------------------------------
multi4x4:
    push	rbp
    mov     rbp,rsp

        xor rax,rax
        mov rcx,4
	vzeroall		; zerujhemy wszystkie rejestry ymm	
.loop:       
        vmovapd ymm0, [rsi]
        
        vbroadcastsd ymm1,[rdi+rax]
        vfmadd231pd ymm12,ymm1,ymm0
        
        vbroadcastsd ymm1,[rdi+32+rax]
        vfmadd231pd ymm13,ymm1,ymm0
        
        vbroadcastsd ymm1,[rdi+64+rax]
        vfmadd231pd ymm14,ymm1,ymm0
        
        vbroadcastsd ymm1,[rdi+96+rax]
        vfmadd231pd ymm15,ymm1,ymm0

        add rax,8   ; jeden element ma 8 bajtów, 64 bity
        add rsi,32 ; każdy wiersz ma 32 bajty, 256 bitów

        loop .loop

; przenosimy wynik do pamięci, wiersz po wierszu
       vmovapd  [rdx], ymm12
       vmovapd  [rdx+32], ymm13
       vmovapd  [rdx+64], ymm14
       vmovapd  [rdx+96], ymm15
   	xor rax,rax   ; wartość zwrotna
leave
ret 
